/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.geforcemods.securitycraft.entity.FallingOwnableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReinforcedFallingBlock
extends BaseReinforcedBlock {
    public ReinforcedFallingBlock(Block disguisedBlock) {
        super(disguisedBlock);
    }

    @Override
    public boolean canHarvestBlock(IBlockAccess level, BlockPos pos, EntityPlayer player) {
        return ConfigHandler.alwaysDrop || super.canHarvestBlock(level, pos, player);
    }

    @Override
    public Material func_149688_o(IBlockState state) {
        return this.convertToVanillaState(state).func_185904_a();
    }

    @Override
    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getSoundType(vanillaState, world, pos, entity);
    }

    @Override
    public MapColor func_180659_g(IBlockState state, IBlockAccess level, BlockPos pos) {
        return this.convertToVanillaState(state).func_185909_g(level, pos);
    }

    @Override
    public String getHarvestTool(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestTool(vanillaState);
    }

    @Override
    public boolean isToolEffective(String type, IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().isToolEffective(type, vanillaState);
    }

    @Override
    public int getHarvestLevel(IBlockState state) {
        IBlockState vanillaState = this.convertToVanillaState(state);
        return vanillaState.func_177230_c().getHarvestLevel(vanillaState);
    }

    @Override
    public boolean func_149751_l(IBlockState state) {
        return this.convertToVanillaState(state).func_185895_e();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        world.func_175684_a(pos, (Block)this, this.func_149738_a(world));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && (world.func_175623_d(pos.func_177977_b()) || ReinforcedFallingBlock.canFallThrough(world.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K && world.func_175625_s(pos) instanceof IOwnable) {
                    world.func_72838_d((Entity)new FallingOwnableBlock(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos), ((IOwnable)world.func_175625_s(pos)).getOwner()));
                }
            } else {
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((world.func_175623_d(blockpos) || ReinforcedFallingBlock.canFallThrough(world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public int func_149738_a(World world) {
        return 2;
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(16) == 0 && ReinforcedFallingBlock.canFallThrough(world.func_180495_p(pos.func_177977_b()))) {
            double particleX = (float)pos.func_177958_n() + rand.nextFloat();
            double particleY = (double)pos.func_177956_o() - 0.05;
            double particleZ = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.FALLING_DUST, particleX, particleY, particleZ, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }
}

